<?php
include 'indexapoteker.php';

$user_role = isset($_SESSION['role']) ? $_SESSION['role'] : '';
$user_id = isset($_SESSION['id']) ? $_SESSION['id'] : '';

?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Mutasi Stok</h2>
                <?php if ($user_role != 'kepala_puskesmas') { ?>
                <button class="btn btn-primary rounded" data-bs-toggle="modal" data-bs-target="#addMutasiModal">
                    <i class="ti ti-plus"></i> Tambah Mutasi
                </button>
                <?php } ?>
            </div>
        </div>

        <!-- Filter Laporan -->
        <div class="row mb-3">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Filter Laporan Mutasi</h5>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="" id="filterForm">
                            <div class="row align-items-end">
                                <div class="col-md-2">
                                    <label for="tanggal_dari" class="form-label">Tanggal Dari</label>
                                    <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" value="<?= isset($_GET['tanggal_dari']) ? $_GET['tanggal_dari'] : '' ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="tanggal_sampai" class="form-label">Tanggal Sampai</label>
                                    <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" value="<?= isset($_GET['tanggal_sampai']) ? $_GET['tanggal_sampai'] : '' ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="tipe" class="form-label">Tipe</label>
                                    <select class="form-select" id="tipe" name="tipe">
                                        <option value="">Semua</option>
                                        <option value="KELUAR" <?= (isset($_GET['tipe']) && $_GET['tipe'] == 'KELUAR') ? 'selected' : '' ?>>KELUAR</option>
                                        <option value="MASUK" <?= (isset($_GET['tipe']) && $_GET['tipe'] == 'MASUK') ? 'selected' : '' ?>>MASUK</option>
                                        <option value="ADJUSTMENT" <?= (isset($_GET['tipe']) && $_GET['tipe'] == 'ADJUSTMENT') ? 'selected' : '' ?>>ADJUSTMENT</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="sumber" class="form-label">Sumber</label>
                                    <select class="form-select" id="sumber" name="sumber">
                                        <option value="">Semua</option>
                                        <option value="PENGGUNAAN" <?= (isset($_GET['sumber']) && $_GET['sumber'] == 'PENGGUNAAN') ? 'selected' : '' ?>>PENGGUNAAN</option>
                                        <option value="RETUR" <?= (isset($_GET['sumber']) && $_GET['sumber'] == 'RETUR') ? 'selected' : '' ?>>RETUR</option>
                                        <option value="STOK_OPNAME" <?= (isset($_GET['sumber']) && $_GET['sumber'] == 'STOK_OPNAME') ? 'selected' : '' ?>>STOK OPNAME</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="ti ti-filter"></i> Filter
                                    </button>
                                </div>
                            </div>
                        </form>
                        
                        <?php if (isset($_GET['tanggal_dari']) || isset($_GET['tanggal_sampai']) || isset($_GET['tipe']) || isset($_GET['sumber'])) { ?>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <a href="pengeluaranapoteker.php" class="btn btn-secondary btn-sm">
                                    <i class="ti ti-refresh"></i> Reset Filter
                                </a>
                                <?php if ($user_role == 'kepala_puskesmas') { ?>
                                <button type="button" class="btn btn-success btn-sm ms-2" onclick="cetakLaporan()">
                                    <i class="ti ti-printer"></i> Cetak Laporan
                                </button>
                                <?php } ?>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Mutasi Stok</h5>
                        <small>Kelola mutasi stok (keluar, masuk, adjustment)</small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Tanggal</th>
                                        <th>Nama Obat</th>
                                        <th>Tipe</th>
                                        <th>Sumber</th>
                                        <th>Jumlah</th>
                                        <th>Keterangan</th>
                                        <?php if ($user_role == 'kepala_puskesmas') { ?>
                                        <th>Petugas</th>
                                        <?php } ?>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   <?php
                                    // Untuk kepala_puskesmas, tampilkan semua data
                                    // Untuk role lain, filter berdasarkan user_id
                                    $where_clauses = [];
                                    
                                    if ($user_role != 'kepala_puskesmas') {
                                        $where_clauses[] = "m.id_user = '$user_id'";
                                    }
                                    
                                    if (isset($_GET['tanggal_dari']) && !empty($_GET['tanggal_dari'])) {
                                        $tanggal_dari = mysqli_real_escape_string($conn, $_GET['tanggal_dari']);
                                        $where_clauses[] = "DATE(m.tanggal) >= '$tanggal_dari'";
                                    }
                                    
                                    if (isset($_GET['tanggal_sampai']) && !empty($_GET['tanggal_sampai'])) {
                                        $tanggal_sampai = mysqli_real_escape_string($conn, $_GET['tanggal_sampai']);
                                        $where_clauses[] = "DATE(m.tanggal) <= '$tanggal_sampai'";
                                    }

                                    if (isset($_GET['tipe']) && !empty($_GET['tipe'])) {
                                        $tipe = mysqli_real_escape_string($conn, $_GET['tipe']);
                                        $where_clauses[] = "m.tipe = '$tipe'";
                                    }
                                    
                                    if (isset($_GET['sumber']) && !empty($_GET['sumber'])) {
                                        $sumber = mysqli_real_escape_string($conn, $_GET['sumber']);
                                        $where_clauses[] = "m.sumber = '$sumber'";
                                    }
                                    
                                    // Filter arah adjustment dari keterangan
                                    if (isset($_GET['arah']) && !empty($_GET['arah'])) {
                                        $arah = mysqli_real_escape_string($conn, $_GET['arah']);
                                        $where_clauses[] = "m.keterangan LIKE '[$arah]%'";
                                    }
                                    
                                    $where_sql = count($where_clauses) > 0 ? implode(" AND ", $where_clauses) : "1=1";
                                    
                                    $query = "SELECT m.*, o.nama_obat, o.satuan, u.username
                                              FROM mutasi_stok m 
                                              LEFT JOIN obat o ON m.id_obat = o.id_obat 
                                              LEFT JOIN users u ON m.id_user = u.id_user
                                              WHERE $where_sql
                                              ORDER BY m.id_mutasi DESC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    
                                    while ($row = mysqli_fetch_assoc($result)) {
                                        $tipe_class = '';
                                        $tipe_icon = '';
                                        switch($row['tipe']) {
                                            case 'KELUAR': 
                                                $tipe_class = 'bg-danger'; 
                                                $tipe_icon = '<i class="ti ti-arrow-down"></i> ';
                                                break;
                                            case 'MASUK': 
                                                $tipe_class = 'bg-success'; 
                                                $tipe_icon = '<i class="ti ti-arrow-up"></i> ';
                                                break;
                                            case 'ADJUSTMENT': 
                                                $tipe_class = 'bg-warning'; 
                                                $tipe_icon = '<i class="ti ti-adjustments"></i> ';
                                                break;
                                        }

                                        // Extract arah dari keterangan untuk ADJUSTMENT
                                        $arah_adjustment = '';
                                        if ($row['tipe'] == 'ADJUSTMENT') {
                                            if (preg_match('/^\[(TAMBAH|KURANG)\]/', $row['keterangan'], $matches)) {
                                                $arah_adjustment = $matches[1];
                                            }
                                        }

                                        $sumber_class = '';
                                        $sumber_display = '';
                                        
                                        if ($row['tipe'] == 'ADJUSTMENT') {
                                            // Untuk ADJUSTMENT, tampilkan sumber + arah
                                            $sumber_display = str_replace('_', ' ', $row['sumber']);
                                            if ($arah_adjustment) {
                                                $sumber_display .= ' - ' . $arah_adjustment;
                                            }
                                            $sumber_class = $arah_adjustment == 'TAMBAH' ? 'bg-success' : 'bg-danger';
                                        } else {
                                            $sumber_display = str_replace('_', ' ', $row['sumber']);
                                            switch($row['sumber']) {
                                                case 'PEMBELIAN': $sumber_class = 'bg-primary'; break;
                                                case 'PENGGUNAAN': $sumber_class = 'bg-info'; break;
                                                case 'RETUR': $sumber_class = 'bg-dark'; break;
                                                case 'STOK_OPNAME': $sumber_class = 'bg-secondary'; break;
                                            }
                                        }

                                        // Tentukan apakah stok bertambah atau berkurang
                                        $is_increase = false;
                                        if ($row['tipe'] == 'MASUK') {
                                            $is_increase = true;
                                        } elseif ($row['tipe'] == 'ADJUSTMENT' && $arah_adjustment == 'TAMBAH') {
                                            $is_increase = true;
                                        }
                                        
                                        $jumlah_class = $is_increase ? 'text-success' : 'text-danger';
                                        $jumlah_prefix = $is_increase ? '+ ' : '- ';
                                        
                                        // Clean keterangan untuk display (hapus [TAMBAH] atau [KURANG])
                                        $keterangan_display = preg_replace('/^\[(TAMBAH|KURANG)\]\s*/', '', $row['keterangan']);
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= date('d/m/Y H:i', strtotime($row['tanggal'])) ?></td>
                                        <td><?= $row['nama_obat'] ?></td>
                                        <td><span class="badge <?= $tipe_class ?>"><?= $row['tipe'] ?></span></td>
                                        <td><span class="badge <?= $sumber_class ?>"><?= $sumber_display ?></span></td>
                                        <td class="<?= $jumlah_class ?>">
                                            <strong><?= $tipe_icon ?><?= $jumlah_prefix ?><?= $row['jumlah'] ?> <?= $row['satuan'] ?></strong>
                                        </td>
                                        <td><?= substr($keterangan_display, 0, 50) ?><?= strlen($keterangan_display) > 50 ? '...' : '' ?></td>
                                        <?php if ($user_role == 'kepala_puskesmas') { ?>
                                        <td><?= $row['username'] ?></td>
                                        <?php } ?>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#detailMutasiModal<?php echo $row['id_mutasi']; ?>" title="Detail">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <?php if ($user_role != 'kepala_puskesmas') { ?>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editMutasiModal<?php echo $row['id_mutasi']; ?>" title="Edit">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteMutasiModal<?php echo $row['id_mutasi']; ?>" title="Hapus">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if ($user_role != 'kepala_puskesmas') { ?>
<!-- Modal Tambah Mutasi -->
<div class="modal fade" id="addMutasiModal" tabindex="-1" aria-labelledby="addMutasiModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMutasiModalLabel">Tambah Mutasi Stok</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="tambahmutasi.php" method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="id_obat_add" class="form-label">Obat <span class="text-danger">*</span></label>
                        <select class="form-select" id="id_obat_add" name="id_obat" required>
                            <option value="">-- Pilih Obat --</option>
                            <?php
                            $obat_query = "SELECT o.*, COALESCE(SUM(s.jumlah), 0) as stok_tersedia
                                          FROM obat o
                                          LEFT JOIN stok s ON o.id_obat = s.id_obat
                                          GROUP BY o.id_obat
                                          ORDER BY o.nama_obat";
                            $obat_result = mysqli_query($conn, $obat_query);
                            while ($obat = mysqli_fetch_assoc($obat_result)) {
                                echo '<option value="'.$obat['id_obat'].'" data-stok="'.$obat['stok_tersedia'].'">'.$obat['nama_obat'].' (Stok: '.$obat['stok_tersedia'].' '.$obat['satuan'].')</option>';
                            }
                            ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="tipe_add" class="form-label">Tipe <span class="text-danger">*</span></label>
                        <select class="form-select" id="tipe_add" name="tipe" required onchange="updateSumberOptions()">
                            <option value="">-- Pilih Tipe --</option>
                            <option value="KELUAR">Keluar</option>
                            <option value="MASUK">Masuk</option>
                            <option value="ADJUSTMENT">Adjustment</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="sumber_add" class="form-label">Sumber <span class="text-danger">*</span></label>
                        <select class="form-select" id="sumber_add" name="sumber" required>
                            <option value="">-- Pilih Tipe Dulu --</option>
                        </select>
                        <small class="text-muted" id="sumber_info_add"></small>
                    </div>

                    <div class="mb-3" id="arah_adjustment" style="display: none;">
                        <label for="arah_add" class="form-label">Arah Adjustment <span class="text-danger">*</span></label>
                        <select class="form-select" id="arah_add" name="arah">
                            <option value="">-- Pilih Arah --</option>
                            <option value="TAMBAH">Tambah Stok (Temuan/Koreksi Lebih)</option>
                            <option value="KURANG">Kurang Stok (Hilang/Koreksi Kurang)</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="jumlah_add" class="form-label">Jumlah <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="jumlah_add" name="jumlah" min="1" required>
                        <small class="text-muted" id="stok_info_add"></small>
                    </div>

                    <div class="mb-3">
                        <label for="keterangan_add" class="form-label">Keterangan</label>
                        <textarea class="form-control" id="keterangan_add" name="keterangan" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary" name="tambah">
                        <i class="ti ti-check"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>

<!-- Modal Detail, Edit, dan Hapus -->
<?php
$where_clauses_modal = [];

if ($user_role != 'kepala_puskesmas') {
    $where_clauses_modal[] = "m.id_user = '$user_id'";
}

if (isset($_GET['tanggal_dari']) && !empty($_GET['tanggal_dari'])) {
    $where_clauses_modal[] = "DATE(m.tanggal) >= '{$_GET['tanggal_dari']}'";
}

if (isset($_GET['tanggal_sampai']) && !empty($_GET['tanggal_sampai'])) {
    $where_clauses_modal[] = "DATE(m.tanggal) <= '{$_GET['tanggal_sampai']}'";
}

if (isset($_GET['tipe']) && !empty($_GET['tipe'])) {
    $where_clauses_modal[] = "m.tipe = '{$_GET['tipe']}'";
}

if (isset($_GET['sumber']) && !empty($_GET['sumber'])) {
    $where_clauses_modal[] = "m.sumber = '{$_GET['sumber']}'";
}

$where_sql_modal = count($where_clauses_modal) > 0 ? implode(" AND ", $where_clauses_modal) : "1=1";

$query = "SELECT m.*, o.nama_obat, o.satuan, o.harga_beli, u.username
          FROM mutasi_stok m 
          LEFT JOIN obat o ON m.id_obat = o.id_obat 
          LEFT JOIN users u ON m.id_user = u.id_user
          WHERE $where_sql_modal
          ORDER BY m.id_mutasi DESC";
$result = mysqli_query($conn, $query);

while ($row = mysqli_fetch_assoc($result)) {
    $tipe_class = '';
    $tipe_icon = '';
    switch($row['tipe']) {
        case 'KELUAR': 
            $tipe_class = 'bg-danger'; 
            $tipe_icon = '<i class="ti ti-arrow-down"></i> ';
            break;
        case 'MASUK': 
            $tipe_class = 'bg-success'; 
            $tipe_icon = '<i class="ti ti-arrow-up"></i> ';
            break;
        case 'ADJUSTMENT': 
            $tipe_class = 'bg-warning'; 
            $tipe_icon = '<i class="ti ti-adjustments"></i> ';
            break;
    }

    $sumber_class = '';
    switch($row['sumber']) {
        case 'PENGGUNAAN': $sumber_class = 'bg-info'; break;
        case 'RETUR': $sumber_class = 'bg-dark'; break;
        case 'STOK_OPNAME': $sumber_class = 'bg-secondary'; break;
    }
?>

<!-- Modal Detail -->
<div class="modal fade" id="detailMutasiModal<?php echo $row['id_mutasi']; ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Mutasi #<?php echo $row['id_mutasi']; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <table class="table table-sm">
                    <tr>
                        <td width="150">Tanggal</td>
                        <td>: <?= date('d/m/Y H:i:s', strtotime($row['tanggal'])) ?></td>
                    </tr>
                    <tr>
                        <td>Obat</td>
                        <td>: <?= $row['nama_obat'] ?></td>
                    </tr>
                    <tr>
                        <td>Tipe</td>
                        <td>: <span class="badge <?= $tipe_class ?>"><?= $row['tipe'] ?></span></td>
                    </tr>
                    <tr>
                        <td>Sumber</td>
                        <td>: <span class="badge <?= $sumber_class ?>"><?= str_replace('_', ' ', $row['sumber']) ?></span></td>
                    </tr>
                    <tr>
                        <td>Jumlah</td>
                        <td>: <strong><?= $tipe_icon ?><?= ($row['tipe'] == 'KELUAR' ? '- ' : '+ ') ?><?= $row['jumlah'] ?> <?= $row['satuan'] ?></strong></td>
                    </tr>
                    <?php if ($user_role == 'kepala_puskesmas') { ?>
                    <tr>
                        <td>Petugas</td>
                        <td>: <?= $row['username'] ?></td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td>Harga Beli/Unit</td>
                        <td>: Rp <?= number_format($row['harga_beli'], 0, ',', '.') ?></td>
                    </tr>
                    <tr>
                        <td>Total Nilai</td>
                        <td>: <strong>Rp <?= number_format($row['harga_beli'] * $row['jumlah'], 0, ',', '.') ?></strong></td>
                    </tr>
                    <tr>
                        <td>Keterangan</td>
                        <td>: <?= $row['keterangan'] ?: '-' ?></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<?php if ($user_role != 'kepala_puskesmas') { ?>
<!-- Modal Edit -->
<div class="modal fade" id="editMutasiModal<?php echo $row['id_mutasi']; ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Mutasi #<?php echo $row['id_mutasi']; ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="editmutasi.php" method="POST">
                <input type="hidden" name="id_mutasi" value="<?php echo $row['id_mutasi']; ?>">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Obat</label>
                        <input type="text" class="form-control" value="<?php echo $row['nama_obat']; ?>" disabled>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Tipe</label>
                        <input type="text" class="form-control" value="<?php echo $row['tipe']; ?>" disabled>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Sumber</label>
                        <input type="text" class="form-control" value="<?php echo $row['sumber']; ?>" disabled>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Jumlah</label>
                        <input type="number" class="form-control" name="jumlah" value="<?php echo $row['jumlah']; ?>" min="1" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea class="form-control" name="keterangan" rows="3"><?php echo $row['keterangan']; ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-warning" name="edit">
                        <i class="ti ti-device-floppy"></i> Perbarui
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus -->
<div class="modal fade" id="deleteMutasiModal<?php echo $row['id_mutasi']; ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="hapusmutasi.php" method="POST">
                <input type="hidden" name="id_mutasi" value="<?php echo $row['id_mutasi']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus mutasi ini?</p>
                    <div class="alert alert-warning">
                        <strong><?= $row['nama_obat'] ?></strong><br>
                        Tipe: <?= $row['tipe'] ?><br>
                        Jumlah: <?= $row['jumlah'] ?> <?= $row['satuan'] ?><br>
                        Sumber: <?= $row['sumber'] ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus">
                        <i class="ti ti-trash"></i> Hapus
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>

<?php } ?>

<script>
function updateSumberOptions() {
    const tipe = document.getElementById('tipe_add').value;
    const sumberSelect = document.getElementById('sumber_add');
    const arahAdjustment = document.getElementById('arah_adjustment');
    const sumberInfo = document.getElementById('sumber_info_add');
    
    sumberSelect.innerHTML = '<option value="">-- Pilih Sumber --</option>';
    arahAdjustment.style.display = 'none';
    sumberInfo.innerHTML = '';
    
    if (tipe === 'KELUAR') {
        sumberSelect.innerHTML += `
            <option value="PENGGUNAAN">Penggunaan</option>
            <option value="RETUR">Retur</option>
        `;
        sumberInfo.innerHTML = 'Stok akan berkurang';
    } else if (tipe === 'MASUK') {
        sumberSelect.innerHTML += `
            <option value="PENGGUNAAN">Penggunaan</option>
            <option value="RETUR">Retur</option>
        `;
        sumberInfo.innerHTML = 'Stok akan bertambah';
    } else if (tipe === 'ADJUSTMENT') {
        sumberSelect.innerHTML += `
            <option value="STOK_OPNAME">Stok Opname</option>
        `;
        arahAdjustment.style.display = 'block';
        sumberInfo.innerHTML = 'Pilih arah adjustment untuk penyesuaian stok';
    }
}

document.getElementById('id_obat_add').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    const stok = selectedOption.getAttribute('data-stok') || '0';
    document.getElementById('stok_info_add').textContent = 'Stok tersedia: ' + stok;
});

function cetakLaporan() {
    const params = new URLSearchParams(window.location.search);
    const tanggalDari = params.get('tanggal_dari') || '';
    const tanggalSampai = params.get('tanggal_sampai') || '';
    const tipe = params.get('tipe') || '';
    const sumber = params.get('sumber') || '';
    const idGudang = params.get('id_gudang') || '';
    
    const url = `cetaklaporanpengeluaran.php?tanggal_dari=${tanggalDari}&tanggal_sampai=${tanggalSampai}&tipe=${tipe}&sumber=${sumber}&id_gudang=${idGudang}`;
    window.open(url, '_blank');
}
</script>

<?php include 'footer.php'; ?>